% OLSVARC.M
% Lutz Kilian
% University of Michigan
% April 1997
%
% Modified by Domenico Ferraro 2010
% This program estimates a level VAR with intercept in companion format by LS

function [A,SIGMA,U,V,BOLS]=olsvarc(y,p)
    
    % OUTPUT:
    % BOLS = VAR coeffcients in companion form
    % A = VAR coefficients in companion form (constant excluded)
    % V = vector of constants in companion form 
    % SIGMA = VAR-COV matrix of VAR residuals in companion form
    % U = matrix of VAR residuals in companion form
    % INPUT:
    % y = raw data
    % p = # of lags in VAR

global q

ndeterm=1; % # of deterministic terms (1 if constant only; 2 if constant and time trend)
[t,q]=size(y);
y=y';
Y=y(:,p:t);	
for i=1:p-1
 	Y=[Y; y(:,p-i:t-i)];
end;

%trend=(1:1:t-p); 
X=[ones(1,t-p); Y(:,1:t-p)]; % include trend here if needed
Y=Y(:,2:t-p+1);

A=(Y*X')/(X*X'); 
U=Y-A*X;
SIGMA=U*U'/(t-p*q-ndeterm);
BOLS=A;
V=A(:,1); % V=A(:,1:ndeterm) if trend needed 
A=A(:,ndeterm+1:q*p+ndeterm);




